
# 手把手带你实现存储引擎


之前在 [刷题攻略登上榜首](https://mp.weixin.qq.com/s/wZRTrA9Rbvgq1yEkSw4vfQ)这篇文章中说过，Carl不仅写了刷题攻略，还写了很多优秀的开源项目。

在星球里也有很多小伙伴问我关于一些，项目的选择，**相信如果是C++后台开发路线的话，基本都会去做WebServer 服务器**。

我在[知识星球](https://programmercarl.com/other/kstar.html)给小伙伴答疑，包括看了这么多简历，**发现WebServer这个项目是真的多，有点烂大街了**。

所以今天我把自己曾经开发的 KV存储引擎 给大家介绍一波，大家可以拿去当做自己的项目经验。

**相信只要是搞后端的同学应该都要熟悉非关系型数据库redis吧，那么应该知道redis的存储引擎是跳表实现的**。

现在很多云厂商提供的云数据库，其底层都是用了Facebook开源的rocksdb，而rocksdb的底层是Google开源的Levedb，**而Levedb的核心实现也是跳表**。

所以大家应该知道跳表的应用有多么的广泛了。

那么为什么这个项目非常合适大家用来做自己的项目经验呢？

如果你是后端开发的话，你在简历上一定会写熟悉或者了解redis吧，那么可以进一步介绍一下自己的项目用跳表实现了redis核心引擎。

面试官一定会非常感兴趣的，然后你就可以和面试官侃侃而谈你是如何用跳表实现的这个KV存储引擎的。

**瞬间逼格就高了，有木有！**

我在18年的时候，用跳表实现了一个轻量级KV存储引擎，代码也写的非常规范，熟悉我的录友应该知道，我的代码严格按照Google C++ style来的。

因为当时我是想把这个项目国际化的，注释和readme都是英文的，但最近我把这个项目又汉化回来了，方便大家理解。

给大家先随意看一段代码，我在注释中其实就已经在讲解跳表的运行原理了。代码使用了C++模板编程，这样接口支持任意类型的数据（包括自己自定义的类）

![](https://file1.kamacoder.com/i/algo/20221104121454.png)

项目地址：**https://github.com/youngyangyang04/Skiplist-CPP**

这个项目中的代码质量是非常高的，如果无论是C++特性的运用，还是代码风格都是绝对拿得出手的！

好了，牛逼吹完，然后给大家正式介绍一下这个项目

## KV存储引擎

本项目就是基于跳表实现的轻量级键值型存储引擎，使用C++实现。插入数据、删除数据、查询数据、数据展示、数据落盘、文件加载数据，以及数据库大小显示。

在随机写读情况下，该项目每秒可处理啊请求数（QPS）: 24.39w，每秒可处理读请求数（QPS）: 18.41w

## 项目展示

![](https://file1.kamacoder.com/i/algo/20221104121509.png)

文件功能：

* main.cpp 包含skiplist.h使用跳表进行数据操作
* skiplist.h 跳表核心实现
* README.md 中文介绍
* README-en.md 英文介绍
* bin 生成可执行文件目录
* makefile 编译脚本
* store 数据落盘的文件存放在这个文件夹
* stress_test_start.sh 压力测试脚本
* LICENSE 使用协议


## 提供接口

* insertElement（插入数据）
* deleteElement（删除数据）
* searchElement（查询数据）
* displayList（展示已存数据）
* dumpFile（数据落盘）
* loadFile（文件加载数据）
* size（返回数据规模）

## 存储引擎数据表现

### 插入操作

跳表树高：18

采用随机插入数据测试：


|插入数据规模（万条） |耗时（秒） |
|---|---|
|10 |0.316763 |
|50 |1.86778 |
|100 |4.10648 |


每秒可处理写请求数（QPS）: 24.39w

### 取数据操作

|取数据规模（万条） |耗时（秒） |
|---|---|
|10|0.47148 |10|
|50|2.56373 |50|
|100|5.43204 |100|

每秒可处理读请求数（QPS）: 18.41w

## 项目运行方式

```
make            // complie demo main.cpp
./bin/main      // run
```

运行截图：（其中展示了插入数据，删除数据，展示数据等等功能）

![](https://file1.kamacoder.com/i/algo/20221104121525.png)

如果想自己写程序使用这个kv存储引擎，只需要在你的CPP文件中include skiplist.h 就可以了。

可以运行如下脚本测试kv存储引擎的性能（当然你可以根据自己的需求进行修改）

```
sh stress_test_start.sh
```

项目地址：**https://github.com/youngyangyang04/Skiplist-CPP**

**大家白嫖的同时，别忘了给个star，fork，支持一波！** 录友如果最后拿到offer了，也别忘了和我道个喜哦。

